



export const RenewalTypes = [
	{ value: 'none',    description: 'None' }
	, { value: 'week',  description: 'Weekly' }
	, { value: 'month', description: 'Monthly' }
//	, { value: 'year',  description: 'Yearly' }
];



let cachedSalesSettings = null;
export const getSalesSettings = async () => {
	if (cachedSalesSettings == null) {
		let r = await postJson( '/service/sales/settings.do' );
		
		let json = await r.json();
		
		cachedSalesSettings = json.settings;
		
		cachedVats = json.vats;
	}
	
	return cachedSalesSettings;
};

let cachedVats = null;
export const getVats = async () => {
	await getSalesSettings();
	
	let r = [];
	for(let i = 0; i < cachedVats.length; i++) {
		r.push({
			value: cachedVats[i].vatId,
			description: cachedVats[i].description,
			defaultSelected: cachedVats[i].defaultSelected
		});
	}
	
	return r;
}


